/* 
 *  SupervisorIntrinsicsTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

public class SupervisorIntrinsicsTab extends KVPTabBase {

    public SupervisorIntrinsicsTab() {
        super("Intrinsic");
    }

    @Override
    void update(InteractionDataI data) {
        getTab().setDisable(!data.canSetIntrinsic());
        getList().clear();
        getList().addAll(KVPItem.convertIntrinsicsList(data.getIntrinsics()));
    }

}
